/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.blockEntity;

import cc.tweaked_programs.cccbridge.BlockRegister;
import cc.tweaked_programs.cccbridge.CCCSoundEvents;
import cc.tweaked_programs.cccbridge.peripherals.ScrollerBlockPeripheral;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ScrollerBlockEntity
extends SmartTileEntity {
    private ScrollerBlockPeripheral peripheral;
    private boolean locked = false;
    private boolean updateLock = false;
    private boolean playTickSound = false;

    public ScrollerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegister.SCROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public IPeripheral getPeripheral(Direction side) {
        if (side == ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_()) {
            if (this.peripheral == null) {
                this.peripheral = new ScrollerBlockPeripheral(this, this.m_58904_());
            }
            return this.peripheral;
        }
        return null;
    }

    public void setLock(boolean state) {
        this.locked = state;
        this.updateLock = true;
    }

    public void playTickSound() {
        this.playTickSound = true;
    }

    @Nullable
    public ScrollValueBehaviour getBehaviour() {
        TileEntityBehaviour behaviour = this.getBehaviour(ScrollValueBehaviour.TYPE);
        if (behaviour instanceof ScrollValueBehaviour) {
            ScrollValueBehaviour scrollValueBehaviour = (ScrollValueBehaviour)behaviour;
            return scrollValueBehaviour;
        }
        return null;
    }

    public static void tick(Level world, BlockPos blockPos, BlockState state, BlockEntity be) {
        if (!(be instanceof ScrollerBlockEntity)) {
            return;
        }
        ScrollerBlockEntity scroller = (ScrollerBlockEntity)be;
        if (scroller.updateLock && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61444_) != scroller.locked) {
            world.m_5594_(null, blockPos, scroller.locked ? CCCSoundEvents.CAGE_LOCK : CCCSoundEvents.CAGE_UNLOCK, SoundSource.BLOCKS, 1.0f, 1.5f);
            world.m_7731_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61444_, (Comparable)Boolean.valueOf(scroller.locked)), 19);
            scroller.updateLock = false;
        }
        if (scroller.playTickSound) {
            world.m_5594_(null, blockPos, AllSoundEvents.SCROLL_VALUE.getMainEvent(), SoundSource.BLOCKS, 0.25f, 1.5f);
            scroller.playTickSound = false;
        }
        scroller.tick();
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        ScrollValueBehaviour scroller = new ScrollValueBehaviour((Component)this.m_58900_().m_60734_().m_49954_(), (SmartTileEntity)this, (ValueBoxTransform)new ControllerValueBoxTransform()).between(-150, 150).moveText(new Vec3(9.0, 0.0, 10.0)).withUnit(i -> new TranslatableComponent("cccbridge.general.unit.scroller")).withCallback(i -> {
            if (this.peripheral != null) {
                this.peripheral.newValue((int)i);
            }
        }).onlyActiveWhen(() -> (Boolean)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61444_) == false).withStepFunction(context -> context.shift ? 1 : 10).withFormatter(i -> {
            StringBuilder number = new StringBuilder(String.valueOf(i));
            if (i <= -10 || i >= 10) {
                number.insert(number.length() - 1, '.');
            } else {
                number.insert(i >= 0 ? 0 : 1, "0.");
            }
            return number.toString();
        });
        scroller.value = 0;
        behaviours.add((TileEntityBehaviour)scroller);
    }

    private static class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)0.5);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == direction;
        }

        protected float getScale() {
            return 0.5f;
        }
    }
}

